***********************************************************************
11/23/11: ADDED 2010 DATA

***********************************************************************;
LIBNAME alldat '~/jim/data';
*%INCLUDE "~/jim/gzipseq.mcr";

*******  MTAB FILES   **********;
 
filename mtab801 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0003-Data.txt.gz';
filename mtab802 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0007-Data.txt.gz';
filename mtab803 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0011-Data.txt.gz';
filename mtab804 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0015-Data.txt.gz';

filename mtab811 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0019-Data.txt.gz';
filename mtab812 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0023-Data.txt.gz';
filename mtab813 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0027-Data.txt.gz';
filename mtab814 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0031-Data.txt.gz';
filename mtab815 pipe 'gunzip -c ~/jim/data/ce_mtab/1980_81/08423-0035-Data.txt.gz';

filename mtab841 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0003-Data.txt.gz';
filename mtab842 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0007-Data.txt.gz';
filename mtab843 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0011-Data.txt.gz';
filename mtab844 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0015-Data.txt.gz';

filename mtab851 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0003-Data.txt.gz';
filename mtab852 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0007-Data.txt.gz';
filename mtab853 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0011-Data.txt.gz';
filename mtab854 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0015-Data.txt.gz';
filename mtab855 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0019-Data.txt.gz';

filename mtab861 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0003-Data.txt.gz';
filename mtab862 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0007-Data.txt.gz';
filename mtab863 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0011-Data.txt.gz';
filename mtab864 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0015-Data.txt.gz';

filename mtab871 pipe 'gunzip -c ~/jim/data/ce_mtab/1987/09332-0003-Data.txt.gz';
filename mtab872 pipe 'gunzip -c ~/jim/data/ce_mtab/1987/09332-0007-Data.txt.gz';
filename mtab873 pipe 'gunzip -c ~/jim/data/ce_mtab/1987/09332-0011-Data.txt.gz';
filename mtab874 pipe 'gunzip -c ~/jim/data/ce_mtab/1987/09332-0015-Data.txt.gz';

filename mtab881 pipe 'gunzip -c ~/jim/data/ce_mtab/1988/09451-0003-Data.txt.gz';
filename mtab882 pipe 'gunzip -c ~/jim/data/ce_mtab/1988/09451-0007-Data.txt.gz';
filename mtab883 pipe 'gunzip -c ~/jim/data/ce_mtab/1988/09451-0011-Data.txt.gz';
filename mtab884 pipe 'gunzip -c ~/jim/data/ce_mtab/1988/09451-0015-Data.txt.gz';

filename mtab891 pipe 'gunzip -c ~/jim/data/ce_mtab/1989/09712-0003-Data.txt.gz';
filename mtab892 pipe 'gunzip -c ~/jim/data/ce_mtab/1989/09712-0007-Data.txt.gz';
filename mtab893 pipe 'gunzip -c ~/jim/data/ce_mtab/1989/09712-0011-Data.txt.gz';
filename mtab894 pipe 'gunzip -c ~/jim/data/ce_mtab/1989/09712-0015-Data.txt.gz';

filename mtab901 pipe 'gunzip -c ~/jim/data/ce_mtab/1990/09820-0003-Data.txt.gz';
filename mtab902 pipe 'gunzip -c ~/jim/data/ce_mtab/1990/09820-0007-Data.txt.gz';
filename mtab903 pipe 'gunzip -c ~/jim/data/ce_mtab/1990/09820-0011-Data.txt.gz';
filename mtab904 pipe 'gunzip -c ~/jim/data/ce_mtab/1990/09820-0015-Data.txt.gz';

filename mtab911 pipe 'gunzip -c ~/jim/data/ce_mtab/1991/06209-0003-Data.txt.gz';
filename mtab912 pipe 'gunzip -c ~/jim/data/ce_mtab/1991/06209-0007-Data.txt.gz';
filename mtab913 pipe 'gunzip -c ~/jim/data/ce_mtab/1991/06209-0011-Data.txt.gz';
filename mtab914 pipe 'gunzip -c ~/jim/data/ce_mtab/1991/06209-0015-Data.txt.gz';

filename mtab921 pipe 'gunzip -c ~/jim/data/ce_mtab/1992/06372-0003-Data.txt.gz';
filename mtab922 pipe 'gunzip -c ~/jim/data/ce_mtab/1992/06372-0007-Data.txt.gz';
filename mtab923 pipe 'gunzip -c ~/jim/data/ce_mtab/1992/06372-0011-Data.txt.gz';
filename mtab924 pipe 'gunzip -c ~/jim/data/ce_mtab/1992/06372-0015-Data.txt.gz';

filename mtab931 pipe 'gunzip -c ~/jim/data/ce_mtab/1993/da6580.mtab.q931.gz';
filename mtab932 pipe 'gunzip -c ~/jim/data/ce_mtab/1993/da6580.mtab.q932.gz';
filename mtab933 pipe 'gunzip -c ~/jim/data/ce_mtab/1993/da6580.mtab.q933.gz';
filename mtab934 pipe 'gunzip -c ~/jim/data/ce_mtab/1993/da6580.mtab.q934.gz';

filename mtab941 pipe 'gunzip -c ~/jim/data/ce_mtab/1994/da6710.mtab.q941.gz';
filename mtab942 pipe 'gunzip -c ~/jim/data/ce_mtab/1994/da6710.mtab.q942.gz';
filename mtab943 pipe 'gunzip -c ~/jim/data/ce_mtab/1994/da6710.mtab.q943.gz';
filename mtab944 pipe 'gunzip -c ~/jim/data/ce_mtab/1994/da6710.mtab.q944.gz';

filename mtab951 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q951.gz';
filename mtab952 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q952.gz';
filename mtab953 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q953.gz';
filename mtab954 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q954.gz';
filename mtab955 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q955.gz';

filename mtab961 pipe 'gunzip -c ~/jim/data/ce_mtab/1996/02794-0003-Data.txt.gz';
filename mtab962 pipe 'gunzip -c ~/jim/data/ce_mtab/1996/02794-0007-Data.txt.gz';
filename mtab963 pipe 'gunzip -c ~/jim/data/ce_mtab/1996/02794-0011-Data.txt.gz';
filename mtab964 pipe 'gunzip -c ~/jim/data/ce_mtab/1996/02794-0015-Data.txt.gz';

filename mtab971 pipe 'gunzip -c ~/jim/data/ce_mtab/1997/mtabi971X.txt.gz';
filename mtab972 pipe 'gunzip -c ~/jim/data/ce_mtab/1997/mtabi972.txt.gz';
filename mtab973 pipe 'gunzip -c ~/jim/data/ce_mtab/1997/mtabi973.txt.gz';
filename mtab974 pipe 'gunzip -c ~/jim/data/ce_mtab/1997/mtabi974.txt.gz';

filename mtab981 pipe 'gunzip -c ~/jim/data/ce_mtab/1998/da2971.mtab981.gz';
filename mtab982 pipe 'gunzip -c ~/jim/data/ce_mtab/1998/da2971.mtab982.gz';
filename mtab983 pipe 'gunzip -c ~/jim/data/ce_mtab/1998/da2971.mtab983.gz';
filename mtab984 pipe 'gunzip -c ~/jim/data/ce_mtab/1998/da2971.mtab984.gz';

filename mtab991 pipe 'gunzip -c ~/jim/data/ce_mtab/1999/da3228.mtab991.gz';
filename mtab992 pipe 'gunzip -c ~/jim/data/ce_mtab/1999/da3228.mtab992.gz';
filename mtab993 pipe 'gunzip -c ~/jim/data/ce_mtab/1999/da3228.mtab993.gz';
filename mtab994 pipe 'gunzip -c ~/jim/data/ce_mtab/1999/da3228.mtab994.gz';

filename mtab1001 pipe 'gunzip -c ~/jim/data/ce_mtab/2000/da3396.mtab001.gz';
filename mtab1002 pipe 'gunzip -c ~/jim/data/ce_mtab/2000/da3396.mtab002.gz';
filename mtab1003 pipe 'gunzip -c ~/jim/data/ce_mtab/2000/da3396.mtab003.gz';
filename mtab1004 pipe 'gunzip -c ~/jim/data/ce_mtab/2000/da3396.mtab004.gz';

filename mtab1011 pipe 'gunzip -c ~/jim/data/ce_mtab/2001/da3674.mtab011.gz';
filename mtab1012 pipe 'gunzip -c ~/jim/data/ce_mtab/2001/da3674.mtab012.gz';
filename mtab1013 pipe 'gunzip -c ~/jim/data/ce_mtab/2001/da3674.mtab013.gz';
filename mtab1014 pipe 'gunzip -c ~/jim/data/ce_mtab/2001/da3674.mtab014.gz';

filename mtab1021 pipe 'gunzip -c ~/jim/data/ce_mtab/2002/03949-0003-Data.txt.gz';
filename mtab1022 pipe 'gunzip -c ~/jim/data/ce_mtab/2002/03949-0007-Data.txt.gz';
filename mtab1023 pipe 'gunzip -c ~/jim/data/ce_mtab/2002/03949-0011-Data.txt.gz';
filename mtab1024 pipe 'gunzip -c ~/jim/data/ce_mtab/2002/03949-0015-Data.txt.gz';

filename mtab1031 pipe 'gunzip -c ~/jim/data/ce_mtab/2003/mtabi031x.txt.gz';
filename mtab1032 pipe 'gunzip -c ~/jim/data/ce_mtab/2003/mtabi032.txt.gz';
filename mtab1033 pipe 'gunzip -c ~/jim/data/ce_mtab/2003/mtabi033.txt.gz';
filename mtab1034 pipe 'gunzip -c ~/jim/data/ce_mtab/2003/mtabi034.txt.gz';

filename mtab1041 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi041x.txt.gz';
filename mtab1042 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi042.txt.gz';
filename mtab1043 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi043.txt.gz';
filename mtab1044 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi044.txt.gz';
filename mtab1045 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi051.txt.gz';


filename mtab1071 pipe 'gunzip -c ~/jim/data/ce_mtab/2007/mtabi071x.txt.gz';
filename mtab1072 pipe 'gunzip -c ~/jim/data/ce_mtab/2007/mtabi072.txt.gz';
filename mtab1073 pipe 'gunzip -c ~/jim/data/ce_mtab/2007/mtabi073.txt.gz';
filename mtab1074 pipe 'gunzip -c ~/jim/data/ce_mtab/2007/mtabi074.txt.gz';

filename mtab1081 pipe 'gunzip -c ~/jim/data/ce_mtab/2008/mtabi081x.txt.gz';
filename mtab1082 pipe 'gunzip -c ~/jim/data/ce_mtab/2008/mtabi082.txt.gz';
filename mtab1083 pipe 'gunzip -c ~/jim/data/ce_mtab/2008/mtabi083.txt.gz';
filename mtab1084 pipe 'gunzip -c ~/jim/data/ce_mtab/2008/mtabi084.txt.gz';

filename mtab1091 pipe 'gunzip -c ~/jim/data/ce_mtab/2009/mtabi091x.txt.gz';
filename mtab1092 pipe 'gunzip -c ~/jim/data/ce_mtab/2009/mtabi092.txt.gz'; 
filename mtab1093 pipe 'gunzip -c ~/jim/data/ce_mtab/2009/mtabi093.txt.gz'; 
filename mtab1094 pipe 'gunzip -c ~/jim/data/ce_mtab/2009/mtabi094.txt.gz'; 

filename mtab1101 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi101x.txt.gz';
filename mtab1102 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi102.txt.gz'; 
filename mtab1103 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi103.txt.gz'; 
filename mtab1104 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi104.txt.gz'; 
filename mtab1105 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi111.txt.gz'; 


*******  ITAB FILES   **********;

filename itab021 pipe 'gunzip -c ~/jim/data/ce_itab/2002/03949-0004-Data.txt.gz';
filename itab022 pipe 'gunzip -c ~/jim/data/ce_itab/2002/03949-0008-Data.txt.gz';
filename itab023 pipe 'gunzip -c ~/jim/data/ce_itab/2002/03949-0012-Data.txt.gz';
filename itab024 pipe 'gunzip -c ~/jim/data/ce_itab/2002/03949-0016-Data.txt.gz';
filename itab025 pipe 'gunzip -c ~/jim/data/ce_itab/2002/03949-0020-Data.txt.gz';




%MACRO read(qyr);
 
  DATA exp&qyr;
   INFILE mtab&qyr ;
   IF 801 LE &qyr LE 955 THEN INPUT newid 1-8 ucc 9-14 cost 15-26 ref_mo 30-31 ref_yr 32-33;
   IF &qyr GE 961 OR &qyr LE 45 THEN INPUT newid 1-8 ucc 9-14 cost 15-26 ref_mo 30-31 ref_yr 32-35;
   qyear=&qyr;
   IF qyear LE 855 THEN newid=9000000+newid;
  RUN;
PROC SORT; 
   BY newid;
RUN; 
PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(510110 510901 510902 850300); 
     VAR cost;
     OUTPUT OUT=vfin&qyr(DROP=_TYPE_ _FREQ_) SUM=vehfin_tot;
RUN;
PROC MEANS; 
RUN;

PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(420110 420120 430110 430120 440110 440120
		  440130 440140 440150 440210 440900); 
     VAR cost;
     OUTPUT OUT=cloth&qyr(DROP=_TYPE_ _FREQ_) SUM=othapar_tot;
RUN;
PROC MEANS; 
RUN;

PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(310312 310330 690111 690112
		  270310 310110 310120 310130 310210 310220
		  310230 310311 310313 310320 310333 310334
		  310341 310342 610130); 
     VAR cost;
     OUTPUT OUT=vid_audio&qyr(DROP=_TYPE_ _FREQ_) SUM=vidaud_tot;
RUN;
PROC MEANS; 
RUN;

PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(790310 790320);
     VAR cost;
     OUTPUT OUT=alco&qyr(DROP=_TYPE_ _FREQ_) SUM=alco_hm_tot;
RUN;
PROC MEANS; 
RUN;

PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(430130);
     VAR cost;
     OUTPUT OUT=lugg&qyr(DROP=_TYPE_ _FREQ_) SUM=luggage_tot;
RUN;
PROC MEANS; 
RUN;

%MEND read;

%read(801);
%read(802);
%read(803);
%read(804);

%read(811);
%read(812);
%read(813);
%read(814);
%read(815);

%read(841);
%read(842);
%read(843);
%read(844);

%read(851);
%read(852);
%read(853);
%read(854);
*%read(855);

%read(861);
%read(862);
%read(863);
%read(864);

%read(871);
%read(872);
%read(873);
%read(874);

%read(881);
%read(882);
%read(883);
%read(884);

%read(891);
%read(892);
%read(893);
%read(894);

%read(901);
%read(902);
%read(903);
%read(904);

%read(911);
%read(912);
%read(913);
%read(914);

%read(921);
%read(922);
%read(923);
%read(924);

%read(931);
%read(932);
%read(933);
%read(934);


DATA alldat.veh_fin_dat;
   SET  vfin801 vfin802 vfin803 vfin804
	vfin811 vfin812 vfin813 vfin814 vfin815
	vfin841 vfin842 vfin843 vfin844
	vfin851 vfin852 vfin853 vfin854
	vfin861 vfin862 vfin863 vfin864
	vfin871 vfin872 vfin873 vfin874
	vfin881 vfin882 vfin883 vfin884
	vfin891 vfin892 vfin893 vfin894
	vfin901 vfin902 vfin903 vfin904
	vfin911 vfin912 vfin913 vfin914
	vfin921 vfin922 vfin923 vfin924
	vfin931 vfin932 vfin933 vfin934;

RUN;
PROC MEANS; 
RUN;
*%gzipsq(work,veh_fin_dat,~/jim/data); 

PROC DATASETS LIBRARY=work; 
DELETE vfin801 vfin802 vfin803 vfin804
        vfin811 vfin812 vfin813 vfin814 vfin815 
        vfin841 vfin842 vfin843 vfin844 
        vfin851 vfin852 vfin853 vfin854 
        vfin861 vfin862 vfin863 vfin864 
        vfin871 vfin872 vfin873 vfin874 
        vfin881 vfin882 vfin883 vfin884 
        vfin891 vfin892 vfin893 vfin894 
        vfin901 vfin902 vfin903 vfin904 
        vfin911 vfin912 vfin913 vfin914 
        vfin921 vfin922 vfin923 vfin924 
        vfin931 vfin932 vfin933 vfin934
RUN;


DATA alldat.oth_appar_dat;
   SET  cloth801 cloth802 cloth803 cloth804
        cloth811 cloth812 cloth813 cloth814 cloth815
        cloth841 cloth842 cloth843 cloth844
        cloth851 cloth852 cloth853 cloth854 
        cloth861 cloth862 cloth863 cloth864
        cloth871 cloth872 cloth873 cloth874
        cloth881 cloth882 cloth883 cloth884
        cloth891 cloth892 cloth893 cloth894
        cloth901 cloth902 cloth903 cloth904
        cloth911 cloth912 cloth913 cloth914
        cloth921 cloth922 cloth923 cloth924
        cloth931 cloth932 cloth933 cloth934;
RUN;
PROC MEANS; 
RUN;

PROC DATASETS LIBRARY=work; 
DELETE 	cloth801 cloth802 cloth803 cloth804
        cloth811 cloth812 cloth813 cloth814 cloth815
        cloth841 cloth842 cloth843 cloth844
        cloth851 cloth852 cloth853 cloth854
        cloth861 cloth862 cloth863 cloth864
        cloth871 cloth872 cloth873 cloth874
        cloth881 cloth882 cloth883 cloth884
        cloth891 cloth892 cloth893 cloth894
        cloth901 cloth902 cloth903 cloth904 
        cloth911 cloth912 cloth913 cloth914 
        cloth921 cloth922 cloth923 cloth924
        cloth931 cloth932 cloth933 cloth934;
RUN;

*%gzipsq(work,oth_appar_dat,~/jim/data); 



***********************************************************************
FOR ALL YEARS CALCULATE THE AUDIO, VIDEO, COMPUTERS CATEGORY
FOR COMPARISONS TO AGGREGATES
***********************************************************************;
%MACRO read2(qyr);
 
  DATA exp&qyr;
   INFILE mtab&qyr ;
   IF 801 LE &qyr LE 955 THEN INPUT newid 1-8 ucc 9-14 cost 15-26 ref_mo 30-31 ref_yr 32-33;
   IF &qyr GE 961 THEN INPUT newid 1-8 ucc 9-14 cost 15-26 ref_mo 30-31 ref_yr 32-35;

   qyear=&qyr;
   IF qyear LE 855 THEN newid=9000000+newid;
  RUN;
PROC SORT; 
   BY newid;
RUN; 
PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     * ADDED 270311 (SAT. RADIO) 310140 (TV) 310314 (DIG. AUDIO PLAYER);
     WHERE ucc IN(310312 310330 690111 690112 
                  270310 310110 310120 310130 310210 310220
                  310230 310311 310313 310320 310333 310334
                  310341 310342 610130 270311 310140 310314); 
     VAR cost;
     OUTPUT OUT=vid_audio&qyr(DROP=_TYPE_ _FREQ_) SUM=vidaud_tot;
RUN;
PROC MEANS; 
RUN;

PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     * ADDED 790330 WHICH STARTS IN 1072;
     WHERE ucc IN(790310 790320 790330);
     VAR cost;
     OUTPUT OUT=alco&qyr(DROP=_TYPE_ _FREQ_) SUM=alco_hm_tot;
RUN;
PROC MEANS; 
RUN;

PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(430130);
     VAR cost;
     OUTPUT OUT=lugg&qyr(DROP=_TYPE_ _FREQ_) SUM=luggage_tot;
RUN;
PROC MEANS; 
RUN;

%MEND read2;

%read2(941);
%read2(942);   
%read2(943); 
%read2(944);
 
%read2(951);
%read2(952);
%read2(953); 
%read2(954);
*%read2(955);

%read2(961);   
%read2(962);   
%read2(963); 
%read2(964); 
                   
%read2(971); 
%read2(972); 
%read2(973);    
%read2(974); 
 
%read2(981);
%read2(982);
%read2(983);
%read2(984);   
 
%read2(991); 
%read2(992);
%read2(993); 
%read2(994);

%read2(1001);   
%read2(1002);
%read2(1003); 
%read2(1004); 
 
%read2(1011);
%read2(1012);
%read2(1013);   
%read2(1014); 
 
%read2(1021);
%read2(1022);
%read2(1023);
%read2(1024); 
 
%read2(1031); 
%read2(1032);
%read2(1033);
%read2(1034);

%read2(1041);
%read2(1042);   
%read2(1043); 
%read2(1044);
%read2(1045);

%read2(1071);
%read2(1072);   
%read2(1073); 
%read2(1074);

%read2(1081);
%read2(1082);   
%read2(1083); 
%read2(1084);

%read2(1091);
%read2(1092);
%read2(1093);
%read2(1094);

%read2(1101);
%read2(1102);
%read2(1103);
%read2(1104);
%read2(1105);


DATA alldat.video_audio_dat; 
   SET  vid_audio801 vid_audio802 vid_audio803 vid_audio804
        vid_audio811 vid_audio812 vid_audio813 vid_audio814 vid_audio815
        vid_audio841 vid_audio842 vid_audio843 vid_audio844
        vid_audio851 vid_audio852 vid_audio853 vid_audio854
        vid_audio861 vid_audio862 vid_audio863 vid_audio864
        vid_audio871 vid_audio872 vid_audio873 vid_audio874
        vid_audio881 vid_audio882 vid_audio883 vid_audio884
        vid_audio891 vid_audio892 vid_audio893 vid_audio894
        vid_audio901 vid_audio902 vid_audio903 vid_audio904
        vid_audio911 vid_audio912 vid_audio913 vid_audio914
        vid_audio921 vid_audio922 vid_audio923 vid_audio924
        vid_audio931 vid_audio932 vid_audio933 vid_audio934
        vid_audio941 vid_audio942 vid_audio943 vid_audio944
        vid_audio951 vid_audio952 vid_audio953 vid_audio954
        vid_audio961 vid_audio962 vid_audio963 vid_audio964
        vid_audio971 vid_audio972 vid_audio973 vid_audio974
        vid_audio981 vid_audio982 vid_audio983 vid_audio984
        vid_audio991 vid_audio992 vid_audio993 vid_audio994
        vid_audio1001 vid_audio1002 vid_audio1003 vid_audio1004
        vid_audio1011 vid_audio1012 vid_audio1013 vid_audio1014
        vid_audio1021 vid_audio1022 vid_audio1023 vid_audio1024
        vid_audio1031 vid_audio1032 vid_audio1033 vid_audio1034
        vid_audio1041 vid_audio1042 vid_audio1043 vid_audio1044 vid_audio1045
        vid_audio1071 vid_audio1072 vid_audio1073 vid_audio1074 
        vid_audio1081 vid_audio1082 vid_audio1083 vid_audio1084 
        vid_audio1091 vid_audio1092 vid_audio1093 vid_audio1094 
        vid_audio1101 vid_audio1102 vid_audio1103 vid_audio1104 vid_audio1105;
RUN; 
PROC MEANS; 
RUN; 

*%gzipsq(work,video_audio_dat,~/jim/data); 

DATA alldat.alco_at_dat; 
   SET  alco801 alco802 alco803 alco804
        alco811 alco812 alco813 alco814 alco815
        alco841 alco842 alco843 alco844
        alco851 alco852 alco853 alco854
        alco861 alco862 alco863 alco864
        alco871 alco872 alco873 alco874 
        alco881 alco882 alco883 alco884
        alco891 alco892 alco893 alco894
        alco901 alco902 alco903 alco904
        alco911 alco912 alco913 alco914
        alco921 alco922 alco923 alco924
        alco931 alco932 alco933 alco934
        alco941 alco942 alco943 alco944
        alco951 alco952 alco953 alco954
        alco961 alco962 alco963 alco964
        alco971 alco972 alco973 alco974
        alco981 alco982 alco983 alco984
        alco991 alco992 alco993 alco994
        alco1001 alco1002 alco1003 alco1004
        alco1011 alco1012 alco1013 alco1014
        alco1021 alco1022 alco1023 alco1024
        alco1031 alco1032 alco1033 alco1034
        alco1041 alco1042 alco1043 alco1044 alco1045
        alco1071 alco1072 alco1073 alco1074 
        alco1081 alco1082 alco1083 alco1084 
        alco1091 alco1092 alco1093 alco1094 
        alco1101 alco1102 alco1103 alco1104 alco1105;
RUN; 
PROC MEANS; 
RUN; 

*%gzipsq(work,alco_at_dat,~/jim/data); 

DATA alldat.luggage_dat; 
   SET  lugg801 lugg802 lugg803 lugg804
        lugg811 lugg812 lugg813 lugg814 lugg815
        lugg841 lugg842 lugg843 lugg844
        lugg851 lugg852 lugg853 lugg854
        lugg861 lugg862 lugg863 lugg864
        lugg871 lugg872 lugg873 lugg874 
        lugg881 lugg882 lugg883 lugg884
        lugg891 lugg892 lugg893 lugg894
        lugg901 lugg902 lugg903 lugg904
        lugg911 lugg912 lugg913 lugg914
        lugg921 lugg922 lugg923 lugg924
        lugg931 lugg932 lugg933 lugg934
        lugg941 lugg942 lugg943 lugg944
        lugg951 lugg952 lugg953 lugg954
        lugg961 lugg962 lugg963 lugg964
        lugg971 lugg972 lugg973 lugg974
        lugg981 lugg982 lugg983 lugg984
        lugg991 lugg992 lugg993 lugg994
        lugg1001 lugg1002 lugg1003 lugg1004
        lugg1011 lugg1012 lugg1013 lugg1014
        lugg1021 lugg1022 lugg1023 lugg1024
        lugg1031 lugg1032 lugg1033 lugg1034
        lugg1041 lugg1042 lugg1043 lugg1044 lugg1045
        lugg1071 lugg1072 lugg1073 lugg1074 
        lugg1081 lugg1082 lugg1083 lugg1084 
        lugg1091 lugg1092 lugg1093 lugg1094 
        lugg1101 lugg1102 lugg1103 lugg1104 lugg1105;
RUN; 
PROC MEANS; 
RUN; 

*%gzipsq(work,luggage_dat,~/jim/data); 



*  COSTS ARE IN MONTHLY TERMS, SO IF LEASE ONE VEHICLE, VALUE WOULD BE 0.083 FOR 
   EACH OF THE 3 MONTHS IN QTR.  SUMMING OVER THISE WOULD GET .25 FOR QTR, THEN 
   MULTIPLY BY 4 TO GET ANNUAL NUMBER OR "ANNUAL_COST";
%MACRO read_itab(qyr);
 
  DATA inc&qyr;
   INFILE itab&qyr ;
   INPUT newid 1-8 ucc 15-20 cost 22-33 ref_mo 9-10 ref_yr 11-14;
   qyear=1000+&qyr;
   IF qyear LE 855 THEN newid=9000000+newid;

  annual_cost=cost*4;
  RUN;
PROC SORT; 
   BY newid;
RUN; 
PROC MEANS DATA=inc&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(980360);
     VAR annual_cost;
     OUTPUT OUT=veh_lease&qyr(DROP=_TYPE_ _FREQ_) SUM=vehlease_tot;
RUN;
PROC MEANS; 
RUN;

%MEND read_itab;

%read_itab(021);   
%read_itab(022);   
%read_itab(023);   
%read_itab(024);   
%read_itab(025);   

DATA alldat.veh_lease_dat; 
   SET veh_lease021 veh_lease022 veh_lease023 veh_lease024 veh_lease025;
RUN; 
PROC MEANS; 
RUN; 

*%gzipsq(work,veh_lease_dat,~/jim/data); 

